/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XMLElement {
    private String name;
    private Hashtable attributes;
    private Vector children;
    private boolean empty = true;
    private boolean pcdata;
    private XMLElement parent;

    private XMLElement(String string, Hashtable hashtable, Vector vector, boolean bl) {
        this.name = string;
        this.attributes = hashtable;
        this.children = vector;
        this.pcdata = bl;
    }

    public XMLElement(String string, boolean bl) {
        this(string, new Hashtable(), new Vector(), bl);
    }

    public XMLElement(String string, Hashtable hashtable, Vector vector) {
        this(string, hashtable, vector, false);
    }

    public XMLElement(String string) {
        this(string, new Hashtable(), new Vector());
    }

    public XMLElement(String string, Vector vector) {
        this(string, new Hashtable(), vector);
    }

    public XMLElement(String string, Hashtable hashtable) {
        this(string, hashtable, new Vector());
    }

    private boolean has(Vector vector) {
        return !vector.isEmpty() && vector != null;
    }

    public boolean isPCDATA() {
        return this.pcdata;
    }

    public String getElement() {
        return this.name;
    }

    public String[] getAttributes() {
        int n = this.attributes.size();
        String[] stringArray = new String[n];
        Enumeration enumeration = this.attributes.keys();
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public String getAttribute(String string) {
        String string2 = (String)this.attributes.get(string);
        if (string2 == null) {
            throw new RuntimeException("XMLElement " + this.name + " has no attribute " + string);
        }
        return string2;
    }

    public int getIntAttribute(String string) {
        String string2 = (String)this.attributes.get(string);
        if (string2 == null) {
            throw new RuntimeException("XMLElement " + this.name + " has no attribute " + string);
        }
        try {
            return Integer.parseInt((String)this.attributes.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("XMLElement " + this.name + " has no attribute " + string);
        }
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public boolean hasAttribute(String string) {
        return this.attributes.containsKey(string);
    }

    public int countAttributes() {
        return this.attributes.size();
    }

    public void addAttribute(String string, String string2) {
        if (this.isPCDATA()) {
            throw new RuntimeException("You can't add the attribute " + string + " to a PCDATA section");
        }
        this.attributes.put(string, string2);
    }

    public void addAttribute(String string, int n) {
        this.addAttribute(string, Integer.toString(n));
    }

    public XMLElement getParent() {
        return this.parent;
    }

    public XMLElement[] getChildren() {
        Object[] objectArray = new XMLElement[this.children.size()];
        this.children.copyInto(objectArray);
        return objectArray;
    }

    public XMLElement getChild(int n) {
        return (XMLElement)this.children.elementAt(n);
    }

    public boolean hasChildren() {
        return this.has(this.children);
    }

    public int countChildren() {
        return this.children.size();
    }

    public void addChild(XMLElement xMLElement) {
        this.empty = false;
        xMLElement.parent = this;
        this.children.addElement(xMLElement);
    }

    public void addChild(XMLElement xMLElement, int n) {
        this.empty = false;
        xMLElement.parent = this;
        this.children.insertElementAt(xMLElement, n);
    }

    public void removeChild(XMLElement xMLElement) {
        if (this.children.removeElement(xMLElement)) {
            xMLElement.parent = null;
            this.empty = this.children.size() == 0;
        }
    }

    public void removeChild(int n) {
        XMLElement xMLElement = (XMLElement)this.children.elementAt(n);
        this.removeChild(xMLElement);
    }

    public int getDepth() {
        int n = 0;
        XMLElement[] xMLElementArray = this.getChildren();
        for (int i = 0; i < xMLElementArray.length; ++i) {
            n = Math.max(n, xMLElementArray[i].getDepth());
        }
        return 1 + n;
    }

    public int countAllChildren() {
        int n = 0;
        XMLElement[] xMLElementArray = this.getChildren();
        for (int i = 0; i < xMLElementArray.length; ++i) {
            n += xMLElementArray[i].countAllChildren();
        }
        return 1 + n;
    }

    public Vector getSpecificElements(String string) {
        Vector vector = new Vector();
        XMLElement[] xMLElementArray = this.getChildren();
        for (int i = 0; i < xMLElementArray.length; ++i) {
            if (!xMLElementArray[i].isPCDATA()) {
                Enumeration enumeration = xMLElementArray[i].getSpecificElements(string).elements();
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
            }
            if (!xMLElementArray[i].name.equals(string)) continue;
            vector.addElement(xMLElementArray[i]);
        }
        return vector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isPCDATA()) {
            int n = this.name.length();
            block7: for (int i = 0; i < n; ++i) {
                char c = this.name.charAt(i);
                switch (c) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        continue block7;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        continue block7;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        continue block7;
                    }
                    case '\'': {
                        stringBuffer.append("&apos;");
                        continue block7;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
        } else {
            stringBuffer.append("<");
            stringBuffer.append(this.name);
            Enumeration enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append("=\"");
                stringBuffer.append(this.attributes.get(string));
                stringBuffer.append("\"");
            }
            if (this.empty) {
                stringBuffer.append("/>");
            } else {
                stringBuffer.append(">");
            }
        }
        return stringBuffer.toString();
    }

    public void printElementTree(String string) {
        this.printElementTree(System.out, "", string);
    }

    public void printElementTree(String string, String string2) {
        this.printElementTree(System.out, string, string2);
    }

    void printElementTree(PrintStream printStream, String string) {
        this.printElementTree(printStream, "", string);
    }

    void printElementTree(PrintStream printStream, String string, String string2) {
        printStream.println(string + this);
        for (int i = 0; i < this.children.size(); ++i) {
            ((XMLElement)this.children.elementAt(i)).printElementTree(printStream, string + string2, string2);
        }
        if (!this.empty) {
            printStream.println(string + "</" + this.name + ">");
        }
    }
}

